<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-frontend',
    'name' => 'Botleggers Club',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'frontend\controllers',
    //'defaultRoute' => '/index',
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-frontend',
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the frontend
            'name' => 'advanced-frontend',
        ],
        'log' => [
            'traceLevel' =>0,
            
                'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'categories' => ['userinfo'],
                    'levels' => ['info'],
                    'exportInterval' => 1,
                    'logVars' => [],
                    'logFile' => '@app/runtime/logs/userinfo.log',
                ],
                
                
            
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],

        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'login' => 'site/login',
                'botsdata/<group:[A-Za-z0-9_-]+>' => 'botsdata/index',
                'botcommand/<bot:[A-Za-z0-9_-]+>/honeypot' => 'botcommand/honeypot',
                'botcommand/<bot:[A-Za-z0-9_-]+>/testbot' => 'botcommand/testbot',
                'botcommand/<bot:[A-Za-z0-9_-]+>/justbot' => 'botcommand/justbot',
                'botcommand/downloadresult' => '/downloadresult/index',
                'botcommand/<bot:[A-Za-z0-9_-]+>' => 'botcommand/index',
                'downloads/<bot:[A-Za-z0-9_-]+>/<dir:[A-Za-z0-9_-]+>/<file:[^/]+>' => 'downloads/index',
                //[
                    //'class' => 'frontend\components\BotUrlRule',
                //],
            ],
        ],

    ],
    'modules' => [
       'gridview' =>  [
            'class' => '\kartik\grid\Module',
            // your other grid module settings
        ],
       'gridviewKrajee' =>  [
            'class' => '\kartik\grid\Module',
            // your other grid module settings
        ]
    ],
    
    'params' => $params,
];
